# Reporting

Die ELO Business Solution Contract bietet verschiedene Auswertungsmöglichkeiten bestehender Verträge über Microsoft Excel. Dies ermöglicht es, eine Vielzahl von Berichtvorlagen zu hinterlegen, um unterschiedlichsten Anforderungen gerecht zu werden.

Berichte basieren auf Microsoft-Excel-Vorlagen, welche Berechnungen enthalten können. Für unterschiedliche Mitarbeiter können somit individuelle Berichte hinterlegt werden. Im Standard werden folgende Berichtstypen unterstützt:

<a
href="#!/guide/p4EB50366_840B_4BBC_A902_2918E4D3EF11"><span
style='font-weight:bold'>Bericht aller Verträge:</span></a> Liest alle Verträge unterhalb des selektierten Ordners und erzeugt einen Bericht mit den Indexwerten der Verträge.

<a
href="#!/guide/pDFB0DE92_B469_4B97_8768_4619B5EA8FB3"><span
style='font-weight:bold'>Bericht des Zahlungsplans:</span></a> Liest die Zahlungsströme aller Verträge und erzeugt einen Bericht.

## Erzeugen von Berichten

Berichte werden auf Basis bestehender Ablagestrukturen erzeugt. Um eine Auflistung aller Verträge nach den Berechtigungseinstellungen eines Benutzers zu erstellen muss der Wurzelknoten aller Verträge auswählt werden. Im Anschluss kann über die Tab-Gruppe <span
style='font-weight:bold;font-style:italic'>Berichte</span> in der Multifunktionsleiste ein Bericht erzeugt werden.

{@img img1.png}

Verträge müssen dabei nicht direkt unterhalb der selektierten Struktur liegen. Zu beachten ist jedoch, dass bei sehr tiefen Strukturen die Erzeugung der Berichte einige Zeit in Anspruch nehmen kann, da die gesamte Ablagestruktur durchlaufen werden muss. Performanter ist hier der Einsatz von dynamischen Ordnern. Bestehende <a
href="#!/guide/p696709C3_49EB_48C4_9963_DFC565BB36EC">dynamische Ordner</a> der <span
style='font-weight:bold;font-style:italic'>Vertragsüberwachung</span> können hier als Datengrundlage eingesetzt werden.

## Erstellen von Berichtvorlagen

Vorlagen für Berichte basieren auf Microsoft-Excel-Dokumenten im Format XLSX. Alle Vorlagen müssen dabei ein Register <span
style='font-weight:bold;font-style:italic'>Data</span> beinhalten. Dieses Register wird beim Erzeugen des Reports mit allen Daten aus ELO befüllt. Sollen lediglich einige Informationen gesammelt werden, kann der Name der Indexfelder in der ersten Zeile des Data-Registers gesetzt werden. 

<span class="tag_important">Sollen Indexfelder als Datum oder Zahl formatiert werden, muss dies im Kopf der Excel Vorlage hinterlegt werden. (Zellenformat) Diese Vorgehensweise ist notwendig, da Map-Felder keine Typisierung besitzen.</span>

Nachdem ein Bericht erzeugt wurde, zeigt sich das Ergebnis wie folgt.

{@img img3.png}

### Berichte über die Konfiguration hinterlegen

Vorlagen für Berichte können über die Konfiguration des Vertragsmanagements hinterlegt werden. Hierzu stehen zwei getrennte Bereiche für Berichte zur Verfügung.

{@img img5.png}

### Berichte über das ELO Archiv hinterlegen

Berichtsvorlagen müssen in der <span
style='font-weight:bold;font-style:italic'>Reports</span>-Konfiguration der Business Solution Contract hinterlegt werden. Beim Erzeugen eines Berichtes werden alle verfügbaren Vorlagen angeboten.

{@img img7.png}

### Hinweise für den Aufbau von Vorlagen

Mithilfe unterschiedlichster Berechnungsmöglichkeiten (Microsoft-Excel-Standard-Funktionalitäten) können Berichte individuell aufgebaut werden. Die nachfolgende Abbildung zeigt bspw. einen Bericht aller Verträge mit einer Liste der Vertragspartner, gruppiert nach dem Status mithilfe einer <span
style='font-weight:bold;font-style:italic'>Pivot-Tabelle</span>. Berechnungen wurden dabei auf einem eigenen <span
style='font-weight:bold;font-style:italic'>Register</span> (bspw. <span
style='font-weight:bold;font-style:italic'>Auswertung</span>) angewandt werden.

{@img img9.png}

<span
style='font-weight:bold'>Für die Erzeugung eigener Berichte empfiehlt sich die folgende Vorgehensweise:</span>

1.   Es wird ein Bericht von einer bestehenden Vorlage mit einigen Musterdaten erzeugt. 
2.   Der neu erzeugte Bericht wird mit den benötigten Auswertungsmöglichkeiten befüllt und getestet.
3.   Anschließend werden alle Informationen im Data-Register gelöscht.
4.   Der Bericht wird als neue Vorlage in der Konfiguration hinterlegt.

## Ablage von Berichten

Berichte werden im Standard in der Vertragsmanagementstruktur nach Jahr und Monat abgelegt. Zu berücksichtigen ist, dass diese lediglich vom aktuellen Benutzer eingesehen werden können.

{@img img11.png}

Der Standard-Ablagepfad neu angelegter Berichte kann in der Konfigurationsdatei `contract.config` unter `\Administation\Business Solutions Custom\contract\Configuration\` angepasst werden.

## Tipps zu Microsoft Excel

Enthalten Berichtsvorlagen Pivot-Tabellen, so ist es hilfreich, in den <span
style='font-weight:bold;font-style:italic'>PivotTable-Optionen</span> (Rechtsklick auf die Pivot-Tabelle) das <span
style='font-weight:bold;font-style:italic'>Aktualisieren der Tabelle beim Öffnen der Datei</span> zu aktivieren.

Diese Option sorgt dafür, dass nach dem Befüllen der Daten durch ELO eine aktualisierte Ansicht in Microsoft Excel bereitsteht.

{@img img13.png}

## Standardablagepfad für Berichte

Im Standard werden Berichte unter `\Vertragsmanagement\Berichte\Jahr\Monat` abgelegt. Zugriffsrechte auf den eigentlichen Bericht hat jeweils nur der Benutzer, welcher den Bericht erzeugt hat.

Der Ablagepfad für Berichte kann über die Konfiguration des Vertragsmanagements<span
style='font-weight:bold;font-style:italic'> Ablage &amp; Berechtigungen</span> angepasst werden.

{@img img15.png}




